/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQResponse;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class RfQClose
extends SvrProcess {
    private int p_C_RfQ_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            if (para[i].getParameter() != null) {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
        this.p_C_RfQ_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MRfQ rfq = new MRfQ(this.getCtx(), this.p_C_RfQ_ID, this.get_TrxName());
        if (rfq.get_ID() == 0) {
            throw new IllegalArgumentException("No RfQ found");
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("doIt - " + String.valueOf(rfq));
        }
        rfq.setProcessed(true);
        rfq.saveEx();
        int counter = 0;
        MRfQResponse[] responses = rfq.getResponses(false, false);
        int i = 0;
        while (i < responses.length) {
            responses[i].setProcessed(true);
            responses[i].saveEx();
            ++counter;
            ++i;
        }
        StringBuilder msgreturn = new StringBuilder("# ").append(counter);
        return msgreturn.toString();
    }
}

